﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Mouse.Sample4
{
    public partial class FormMain : Form
    {
        [Flags]
        public enum MouseEventFlags : uint
        {
            LeftDown = 0x00000002,
            LeftUp = 0x00000004,
            MiddleDown = 0x00000020,
            MiddleUp = 0x00000040,
            Move = 0x00000001,
            Absolute = 0x00008000,
            RightDown = 0x00000008,
            RightUp = 0x00000010,
            Wheel = 0x00000800,
            XDown = 0x00000080,
            XUp = 0x00000100
        }

        [DllImport("user32.dll")]
        public static extern bool SetCursorPos(int x, int y);

        [DllImport("user32.dll")]
        public static extern void mouse_event(MouseEventFlags dwFlags, int dx, int dy, int dwData, int dwExtraInfo);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonMouseEvent_Click(object sender, EventArgs e)
        {
            SetCursorPos(300, 300);
            mouse_event(MouseEventFlags.LeftDown, 0, 0, 0, 0);
            mouse_event(MouseEventFlags.LeftUp, 0, 0, 0, 0);

            mouse_event(MouseEventFlags.RightDown, 0, 0, 0, 0);
            mouse_event(MouseEventFlags.RightUp, 0, 0, 0, 0);
        }
    }
}